// background.js
chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg && msg.action === "open_math_solver") {
    console.log('background: open_math_solver message received from', sender);

    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      const tab = tabs && tabs[0];
      if (!tab || !tab.id) {
        console.error('background: no active tab to inject into.');
        return;
      }

      // inject content.js into the active tab
      chrome.scripting.executeScript({
        target: { tabId: tab.id },
        files: ['content.js']
      })
      .then(() => {
        console.log('background: content.js injected into tab', tab.id);
      })
      .catch(err => {
        console.error('background: failed to inject content.js', err);
      });
    });

    // no synchronous sendResponse, so return false
    return;
  }

  // keep existing screenshot handler (unchanged)
  if (msg && msg.type === "capture_screenshot") {
    chrome.tabs.captureVisibleTab(null, { format: "png" }, (dataUrl) => {
      if (!dataUrl) {
        sendResponse({ success: false, error: "Could not capture tab." });
      } else {
        sendResponse({ success: true, dataUrl });
      }
    });
    return true; // keep sendResponse async
  }
});


//made by Abhaysingh8313