(async () => {
  if (document.getElementById("mathsnap-floating-container")) return;

  const container = document.createElement("div");
  container.id = "mathsnap-floating-container";
  container.style.cssText = `
    all: initial; /* isolate from page CSS */
    position: fixed;
    top: 100px;
    left: 50px;
    width: 360px;
    background: #ffffff;
    border-radius: 16px;
    box-shadow: 0 12px 36px rgba(0,0,0,0.16);
    z-index: 999999;
    padding: 20px;
    font-family: 'Inter', 'Segoe UI', sans-serif;
    font-size: 14px;
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    align-items: stretch;
  `;
  document.body.appendChild(container);

  // Add isolated internal stylesheet
  const style = document.createElement("style");
  style.innerHTML = `
    #mathsnap-floating-container * {
      all: unset;
      box-sizing: border-box;
    }
    #mathsnap-floating-container h2, h3 {
      font-family: 'Inter', sans-serif;
      font-weight: 600;
      margin: 0 0 14px 0;
      color: #0078d7;
    }
    #mathsnap-floating-container input {
      width: 100%;
      padding: 12px;
      margin-bottom: 10px;
      border: 1px solid #ccc;
      border-radius: 10px;
      font-size: 14px;
      background: #fdfdfd;
      transition: all 0.15s ease;
    }
    #mathsnap-floating-container input:focus {
      border-color: #0078d7;
      box-shadow: 0 2px 8px rgba(0,120,215,0.25);
      outline: none;
    }
    #mathsnap-floating-container button {
      width: 100%;
      padding: 12px;
      margin-top: 10px;
      border-radius: 10px;
      font-weight: 600;
      cursor: pointer;
      text-align: center;
      box-shadow: 0 4px 14px rgba(0,0,0,0.1);
      transition: all 0.2s ease, background 0.2s ease;
      color: white;
    }
    #mathsnap-floating-container button:hover {
      transform: translateY(-1px);
    }
    #mathsnap-floating-container #loginBtn {
      background: #0078d7;
    }
    #mathsnap-floating-container #loginBtn:hover {
      background: #005fa3;
    }
    #mathsnap-floating-container #screenshotBtn {
      background: #28a745;
    }
    #mathsnap-floating-container #screenshotBtn:hover {
      background: #218838;
    }
    #mathsnap-floating-container #message {
      margin-top: 12px;
      color: #e74c3c;
      font-weight: 500;
      word-break: break-word;
    }
    #mathsnap-floating-container pre {
      margin-top: 12px;
      padding: 14px;
      background: #f5f5f5;
      border-radius: 10px;
      white-space: pre-wrap;
      max-height: 240px;
      overflow: auto;
      box-shadow: inset 0 1px 6px rgba(0,0,0,0.08);
      font-family: 'Fira Code', monospace;
      font-size: 13px;
    }
  `;
  document.head.appendChild(style);

  // Load font
  const fontLink = document.createElement("link");
  fontLink.href = "https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap";
  fontLink.rel = "stylesheet";
  document.head.appendChild(fontLink);

  renderLogin(container);
  makeDraggable(container);

  function renderLogin(root) {
    root.innerHTML = `
      <h2>Login</h2>
      <input type="text" id="username" placeholder="Username" />
      <input type="password" id="password" placeholder="Password" />
      <button id="loginBtn">Login</button>
      <p id="message"></p>
    `;

    const loginBtn = root.querySelector("#loginBtn");

    loginBtn.addEventListener("click", async () => {
      const username = root.querySelector("#username").value.trim();
      const password = root.querySelector("#password").value;
      try {
        const res = await fetch("https://sparxext.sparkimc.co.uk/auth/login", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ username, password })
        });
        const data = await res.json();
        if (res.ok && data.token) {
          await chrome.storage.local.set({ token: data.token });
          root.innerHTML = "";
          renderSolver(root);
        } else {
          root.querySelector("#message").innerText = "Login failed: " + (data.detail || "Invalid credentials");
        }
      } catch (err) {
        root.querySelector("#message").innerText = "Error: " + err.message;
      }
    });
  }

  function renderSolver(root) {
  root.innerHTML = `
    <h3>SparkiAi 1.10</h3>
    <button id="screenshotBtn">Solve Question</button>
    <pre id="result">SparkiAi has initiated! To stop, refresh the tab.</pre>
  `;

  const screenshotBtn = root.querySelector("#screenshotBtn");
  const resultEl = root.querySelector("#result");

  screenshotBtn.addEventListener("click", async () => {
    resultEl.innerText = "⏳ Generating response...";

    chrome.runtime.sendMessage({ type: "capture_screenshot" }, async (resp) => {
      if (!resp.success) {
        resultEl.innerText = "❌ Could not capture tab.";
        return;
      }

      try {
        const res = await fetch(resp.dataUrl);
        const blob = await res.blob();
        const formData = new FormData();
        formData.append("file", blob, "screenshot.png");

        const { token } = await chrome.storage.local.get("token");
        if (!token) {
          resultEl.innerText = "⚠️ Please log in first.";
          return;
        }

        const solveRes = await fetch("https://sparxext.sparkimc.co.uk/api/solve", {
          method: "POST",
          headers: { Authorization: `Bearer ${token}` },
          body: formData
        });

        const data = await solveRes.json();

        if (solveRes.ok && data.answer) {
          // Preserve formatting and line breaks
          resultEl.innerText = `✅ Answer:\n${data.answer}`;
        } else {
          resultEl.innerText = `❌ Error: ${data.detail || "Could not solve."}`;
        }

      } catch (err) {
        console.error("Solve error:", err);
        resultEl.innerText = "❌ Error: " + err.message;
      }
    });
  });
}


  function makeDraggable(el) {
    let isDragging = false;
    let offsetX, offsetY;
    el.style.cursor = 'move';

    el.addEventListener('mousedown', (e) => {
      if (["INPUT", "TEXTAREA", "BUTTON"].includes(e.target.tagName)) return;
      isDragging = true;
      offsetX = e.clientX - el.getBoundingClientRect().left;
      offsetY = e.clientY - el.getBoundingClientRect().top;
      document.body.style.userSelect = 'none';
    });

    document.addEventListener('mousemove', (e) => {
      if (!isDragging) return;
      el.style.top = `${e.clientY - offsetY}px`;
      el.style.left = `${e.clientX - offsetX}px`;
    });

    document.addEventListener('mouseup', () => {
      isDragging = false;
      document.body.style.userSelect = '';
    });
  }
})();


//made with love by Abhaysingh8313
